<?php
/* 
================================================================
Application Info: 
Cartweaver 2002 - 2007, All Rights Reserved.
Developer Info: 
	Application Dynamics Inc.
	1560 NE 10th
	East Wenatchee, WA 98802
	Support Info: http://www.cartweaver.com/go/phphelp

Cartweaver Version: 3.0.0  -  Date: 4/21/2007

================================================================
Name: USAEPAY include file
Description: USAEPAY payment processing.

NOTE: Setting up accounts and integrating with third party gateways is not 
a supported feature of Cartweaver. For information and support concerning 
payment gateways contact the appropriate gateway tech support web site or 
personnel. Cartweaver includes this integration code as a courtesy with no 
guarantee or warranty expressed or implied. Gateway providers may make changes 
to their protocols or practices that may affect the code provided here. 
If so, updates and modifications are the sole responsibility of the user.
================================================================
*/
/* 
	Set this value to your usaepay key.
*/
$sourceKey = "YOUR SOURCE KEY HERE";
$debugEmails = true;
$testMode = false;
// Test card number is 4005562233445564


/* Email confirmation notice to company representative */
$companyEmail = $_SESSION["CompanyEmail"];
$developerEmail = $_SESSION["DeveloperEmail"];
$company = $_SESSION["CompanyName"];
include "usaepay.php";

$usaEpay=new umTransaction;

$usaEpay->key = $sourceKey;
$usaEpay->testmode = $testMode;
$usaEpay->card = $ccNumber;		// card number, no dashes, no spaces
$usaEpay->exp = substr($ccExprDate,0,2) . substr($ccExprDate,-2);			// expiration date 4 digits no /
$usaEpay->amount = $_SESSION["orderTotal"];		// charge amount in dollars (no international support yet)
$usaEpay->invoice = "test";   		// invoice number.  must be unique.
$usaEpay->cardholder = $ccardHolderName; 	// name of card holder
$usaEpay->street = $row_rsCWGetCustBilling["cst_Address1"];;	// street address
$usaEpay->zip = $row_rsCWGetCustBilling["cst_Zip"];			// zip code
$usaEpay->description = "Online Order";	// description of charge
$usaEpay->cvv2 = $ccV;			// cvv2 code
$tran->ip=$_SERVER['REMOTE_ADDR'];
	
$usaEpay->ignoresslcerterrors = true;
flush();

$result = $usaEpay->Process();
$response = "";
foreach ($usaEpay as $key => $value) {
	$value = urlencode(stripslashes($value));
	$response .= $key . ": " . urlencode($value) . "\r\n"; // string for emails
}

if($usaEpay->Process()){
	$transactionResult = "Approved";
	$orderStatusID = 2;	
	if($debugEmails) {
		sendEmail($developerEmail,$companyEmail,"Made it to successful transaction","$response");
	}
	$transactionID = $usaEpay->authcode;
	$transactionMessage = $usaEpay->avs_result;
	$transactionMessage .= "\r\n" . $usaEpay->cvv2_result;
} else {
	if($debugEmails) {
		sendEmail($developerEmail,$companyEmail,"Made it to failed transaction","$response");
	}
	$transactionResult = "Failed";
	$transactionMessage = $usaEpay->result;
	$transactionMessage .= "\r\n" . $usaEpay->error;
	if($usaEpay->curlerror) $transactionMessage .= "\r\nCurl Error: " . $usaEpay->curlerror;	
}		

?>
