<?php

function usaepay_settings()

{
	$options = array(
		'usaepay_sourcekey',
		'usaepay_sourcepin',
		'usaepay_sandbox',
		'usaepay_tranmode'
	);
	foreach ( $options as $option ) {
		if ($_POST[$option] !='' )
			update_option( $option, $_POST[$option] );
	}
	return true;
}

function usaepay_settings_form()
{
	$usaepay_sandbox = get_option('usaepay_sandbox');
	$usaepay_sandbox1 = "";
	$usaepay_sandbox2 = "";
	switch($usaepay_sandbox)
	{
		case 0:
			$usaepay_sandbox2 = "checked ='true'";
			break;
		case 1:
			$usaepay_sandbox1 = "checked ='true'";
			break;
		default:
			$usaepay_sandbox2 = "checked ='true'";
	}
	$usaepay_tranmode = get_option('usaepay_tranmode');
	$usaepay_tranmode1 = "";
	$usaepay_tranmode2 = "";
	switch($usaepay_tranmode)
	{
		case 0:
			$usaepay_tranmode2 = "checked ='true'";
			break;
		case 1:
			$usaepay_tranmode1 = "checked ='true'";
			break;
		default:
			$usaepay_tranmode2 = "checked ='true'";
	}
	$output = "
		<tr>
			<td>
				".__( 'Source Key', 'wpsc' )." *
			</td>
			<td>
				<input type='text' size='40' value='". get_option('usaepay_sourcekey')."' name='usaepay_sourcekey' />
			</td>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td><small>This should be set to your source key that has been set up in the Settings - Source Keys section of the USAePay interface.</small></td>
		</tr>
		<tr>
			<td>Source Pin</td>
			<td><input type='text' size='10' value='".get_option('usaepay_sourcepin')."' name='usaepay_sourcepin' /></td>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td><small>(Optional but highly recommended)  The pin increases transaction security and greatly reduces fraud. This pin must match the pin entered in the USAePay interface when setting up the source key.</small></td>
		</tr>
		<tr>
			<td>Sandbox Mode</td>
			<td>
				<input type='radio' value='1' name='usaepay_sandbox' id='usaepay_sandbox1' ".$usaepay_sandbox1." /> <label for='usaepay_sandbox1'>Yes</label> &nbsp;
				<input type='radio' value='0' name='usaepay_sandbox' id='usaepay_sandbox2' ".$usaepay_sandbox2." /> <label for='usaepay_sandbox2'>No</label>
			</td>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td><small>Select 'Yes' to use the Sandbox server.   Your source key must be created on a sandbox account.</small></td>
		</tr>
		<tr>
			<td>Transaction Mode</td>
			<td>
				<input type='radio' value='0' name='usaepay_tranmode' id='usaepay_tranmode2' ". $usaepay_tranmode2." /> <label for='usaepay_tranmode'>Authorize and Capture</label>
				<input type='radio' value='1' name='usaepay_tranmode' id='usaepay_tranmode1' ".$usaepay_tranmode1." /> <label for='usaepay_tranmode1'>Authorize Only</label> &nbsp;
			</td>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td><small>Please select the mode that you would like to process your transaction in. \"Authorization Only\"  will hold funds from your customers credit card and will place the transaction in your Queued Transactions screen.  \"Authorize and Capture\" will also hold funds but will place the transaction into your batch,  ready for settlement.</small></td>
		</tr>
	";
	return $output;
}

function usaepay_checkout_fields() {
	global $gateway_checkout_form_fields;
	if( in_array( 'wpsc_usaepay', (array) get_option('custom_gateway_options') ) ) {		
		$curryear = date( 'Y' );
		$years = '';
		//generate year options
		for ( $i = 0; $i < 10; $i++ ) {
			$years .= "<option value='" . $curryear . "'>" . $curryear . "</option>\r\n";
			$curryear++;
		}
		ob_start(); ?>
		<tr>
			<td class="wpsc_CC_details"> <?php _e( 'Credit Card Number *', 'wpsc' ); ?></td>
			<td>
				<input type="text" value='' name="card_number" />
			</td>
		</tr>
		<tr>
			<td class='wpsc_CC_details'><?php _e( 'Credit Card Expiry *', 'wpsc' ); ?></td>
			<td>
				<select class='wpsc_ccBox' name='expiry[month]'>
					<option value='01'>01</option>
					<option value='02'>02</option>
					<option value='03'>03</option>
					<option value='04'>04</option>
					<option value='05'>05</option>
					<option value='06'>06</option>
					<option value='07'>07</option>
					<option value='08'>08</option>
					<option value='09'>09</option>
					<option value='10'>10</option>
					<option value='11'>11</option>
					<option value='12'>12</option>
				</select>
				<select class='wpsc_ccBox' name='expiry[year]'>
					<?php echo $years; ?>
				</select>
			</td>
		</tr>
		<tr>
			<td class='wpsc_CC_details'><?php _e( 'CVC *', 'wpsc' ); ?></td>
			<td><input type='text' size='4' value='' maxlength='4' name='card_code' /></td>
		</tr>
		<?php
		$gateway_checkout_form_fields['wpsc_usaepay'] = ob_get_clean();
	}
	//echo '<pre>';print_r ( $_SESSION );echo '</pre>';
}

add_action('wpsc_init', 'usaepay_checkout_fields');