<?php

/*

Plugin Name: USAePay WP e-Commerce Plugin

Plugin URI: http://wiki.usaepay.com/merchant/Support/carts/wordpress

Version: 0.2.1

Author: Hung To

Description: A plugin that allows the store owner to process payments by credit cards directly on the website using http://www.usaepay.com.

Author URI:  http://wiki.usaepay.com/merchant/Support/carts/wordpress

*/



/**

	* USAePay WP e-Commerce Plugin

	*

*/

define('USAEPAY_PLUGIN_DIR', dirname(__FILE__));
if (is_ssl() ) {
$wp_content_url = str_replace( 'http://' , 'https://' , WP_PLUGIN_URL);
} else {
$wp_content_url = WP_PLUGIN_URL ;
}
define( 'USAEPAY_HTTP_PATH' , $wp_content_url . '/' . str_replace(basename( __FILE__) , "" , plugin_basename(__FILE__) ) );

include_once( USAEPAY_PLUGIN_DIR . '/includes/functions.php');

include_once( USAEPAY_PLUGIN_DIR . '/includes/usaepay.class.php');

function usaepay_init() {
	include_once(USAEPAY_PLUGIN_DIR . '/usaepay_merchant.php');
	wp_enqueue_script( 'wp-e-commerce-usaepay' , USAEPAY_HTTP_PATH . 'usaepay.js' );
}

add_action('wpsc_init', 'usaepay_init');

// register the gateway

function usaepay_gateway($nzshpcrt_gateways){
	$num = count($nzshpcrt_gateways)+1;
	$nzshpcrt_gateways[$num] = array(
		'name' => 'USAEpay',
		'api_version' => 2.0,
		'class_name' => 'merchant_usaepay',
		'has_recurring_billing' => false,
		'display_name' => 'Credit Card',	
		'wp_admin_cannot_cancel' => false,
		'requirements' => array(
			'php_version' => 5.0
		),
		'form' => 'usaepay_settings_form',
		'submit_function' => 'usaepay_settings',
		'internalname' => 'wpsc_usaepay'
	);
	return $nzshpcrt_gateways; 
}

add_filter('wpsc_merchants_modules','usaepay_gateway');