<?php
class merchant_usaepay extends wpsc_merchant
{
	var $name = 'USAEpay';

	function submit()
	{
		$this->credit_card_details = array(
			'card_number' => $_POST['card_number'],
			'expiry_year' => $_POST['expiry']['year'],
			'expiry_month' => $_POST['expiry']['month'],
			'card_code' => $_POST['card_code']
		);
		
		$tran=new umTransaction;
		$tran->key			= get_option('usaepay_sourcekey');
		$tran->ip 			= $_SERVER['REMOTE_ADDR'];
		// Set transaction mode
		$command  = (get_option('usaepay_tranmode')?'cc:authonly':'cc:sale');
		$tran->command      = $command;
		$tran->usesandbox	= get_option('usaepay_sandbox');
		$tran->pin =  get_option('usaepay_sourcepin');
		//card info
		$tran->card			= $this->credit_card_details['card_number'];
		$tran->exp			= $this->credit_card_details['expiry_month'].$this->credit_card_details['expiry_year'];
		$tran->cvv2			= $this->credit_card_details['card_code'];// cvv2 code
		$tran->amount		= number_format( $this->cart_data['total_price'], 2);			// charge amount in dollars
		$tran->invoice		= $this->cart_data['session_id'];   		// invoice number.  must be unique.
		$tran->cardholder	= $this->cleanInput($this->cart_data['billing_address']['first_name']). ' ' . $this->cleanInput($this->cart_data['billing_address']['last_name']);
		$tran->street		= $this->cart_data['billing_address']['address'];	// street address
		$tran->zip			= $this->cart_data['billing_address']['post_code'];	// zip code
		$tran->description	= get_option('blogname');// description of charge
		// Create Hash
		//$seed = mktime() . rand();
		//$prehash = $command . ':' . get_option('usaepay_sourcepin') . ':' . $tran->amount . ':' . $tran->invoice . ':' . $seed;
		//$data['UMhash'] = 's/' . $seed . '/' . sha1($prehash) . '/y';
		
		// billing info
		$tran->billfname = $this->cart_data['billing_address']['first_name'];
		$tran->billlname = $this->cart_data['billing_address']['last_name'];
		$tran->billstreet = $this->cart_data['billing_address']['address'];
		$tran->billcity = $this->cart_data['billing_address']['city'];
		$tran->billstate = $this->cart_data['billing_address']['state'];
		$tran->billcountry = $this->cart_data['billing_address']['country'];
		$tran->billzip = $this->cart_data['billing_address']['post_code'];
		$tran->billphone = $this->cart_data['billing_address']['phone'];
		$tran->email = $this->cart_data['email_address'];
		
		// shipping info
		$tran->shipfname = $this->cart_data['shipping_address']['first_name'];
		$tran->shiplname = $this->cart_data['shipping_address']['last_name'];
		$tran->shipstreet = $this->cart_data['shipping_address']['address'];
		$tran->shipcity = $this->cart_data['shipping_address']['city'];
		$tran->shipstate = $this->cart_data['shipping_address']['state'];
		$tran->shipcountry = $this->cart_data['shipping_address']['country'];
		$tran->shipzip = $this->cart_data['shipping_address']['post_code'];
		
		// lineItems
		foreach($this->cart_items as $value){
			$tran->addLine('',$value['name'], '',$value['price'],$value['quantity'], '','');
		}
		if($tran->Process())
		{
			//Accepted
			$this->set_transaction_details($tran->authcode, 3);
			transaction_results($this->cart_data['session_id'],false);
			$this->go_to_transaction_results( $this->cart_data['session_id'] );
			exit();		
		}else
		{
			//Declined
			$message .= "<h3>".__( 'Please Check the Payment Results', 'wpsc' )."</h3>";
			$message .= '<strong style="color:red">Your transaction was not successful</strong><br /><br />';
			$message .= '<strong style="color:red">'.$tran->error.'</strong><br /><br />';
			$errors = wpsc_get_customer_meta( 'checkout_misc_error_messages' );
			if ( ! is_array( $errors ) )
				$errors[] = $message;
			wpsc_update_customer_meta( 'checkout_misc_error_messages', $errors );
		}
	}
	private function cleanInput($strRawText){
	$iCharPos = 0;
	$chrThisChar = "";
	$strCleanedText = "";
	$strAllowableChars     = "0123456789 ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_/\(),.:|";
	$blnAllowAccentedChars = TRUE;
	//Compare each character based on list of acceptable characters
	while ( $iCharPos < strlen( $strRawText ) ) {
	  // Only include valid characters **
	  $chrThisChar = substr($strRawText, $iCharPos, 1);
	  if ( strpos( $strAllowableChars, $chrThisChar ) !== FALSE ) {
		  $strCleanedText = $strCleanedText . $chrThisChar;
	  } elseIf ( $blnAllowAccentedChars == TRUE ) {
		// Allow accented characters and most high order bit chars which are harmless **
		if ( ord( $chrThisChar ) >= 191 ) {
			$strCleanedText = $strCleanedText . $chrThisChar;
		}
	  }
	  $iCharPos = $iCharPos + 1;
	}
	return $strCleanedText;
	}
}
?>